<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'company';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'company_name', 'employee_number', 'country_id', 'active_members', 'start_at', 'expire_at', 'grace_at', 'company_domain', 'max_members', 'is_trial', 'active', 'period', 'active_order_id', 'support_start_at');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function active_order()
    {
        return $this->belongsTo('Order', 'active_order_id');
    }

}