<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PackageFeature extends Eloquent {

	protected $table = 'package_feature';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('package_id', 'feature_id');

	public function package()
	{
		return $this->belongsTo('Package', 'package_id');
	}

	public function feature()
	{
		return $this->belongsTo('Feature', 'feature_id');
	}

}