<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GraceHistory extends Eloquent {

	protected $table = 'grace_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'company_id', 'date', 'period', 'order_id');

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}