<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sub_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sub_service_steps', function(Blueprint $table) {
			$table->foreign('sub_service_id')->references('id')->on('sub_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sub_service_advantages', function(Blueprint $table) {
			$table->foreign('sub_service_id')->references('id')->on('sub_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('sub_service_id')->references('id')->on('sub_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('my_services', function(Blueprint $table) {
			$table->foreign('sub_service_id')->references('id')->on('sub_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('my_services', function(Blueprint $table) {
			$table->foreign('foundation_type_id')->references('id')->on('foundation_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sub_services', function(Blueprint $table) {
			$table->dropForeign('sub_services_service_id_foreign');
		});
		Schema::table('sub_service_steps', function(Blueprint $table) {
			$table->dropForeign('sub_service_steps_sub_service_id_foreign');
		});
		Schema::table('sub_service_advantages', function(Blueprint $table) {
			$table->dropForeign('sub_service_advantages_sub_service_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_sub_service_id_foreign');
		});
		Schema::table('my_services', function(Blueprint $table) {
			$table->dropForeign('my_services_sub_service_id_foreign');
		});
		Schema::table('my_services', function(Blueprint $table) {
			$table->dropForeign('my_services_foundation_type_id_foreign');
		});
	}
}