<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->string('patient_name');
			$table->string('patient_age');
			$table->integer('blood_type_id');
			$table->integer('city_id');
			$table->string('hospital_address');
			$table->integer('bags_num');
			$table->string('patient_phone');
			$table->string('hospital_name');
			$table->text('details');
			$table->decimal('latitude', 10,8);
			$table->decimal('longitude', 10,8);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}