<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('password')->nullable();
			$table->tinyInteger('confirmed')->default('0');
			$table->string('confirmed_token', 100)->nullable();
			$table->string('provider')->default('local');
			$table->string('language', 2)->nullable();
			$table->string('authentication')->default('single');
			$table->string('avatar')->nullable();
			$table->rememberToken();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}