<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('type', 10)->default('info');
			$table->string('title');
			$table->string('content');
			$table->boolean('read')->default(0);
			$table->integer('from_user_id')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}