<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkExperiencesTable extends Migration {

	public function up()
	{
		Schema::create('work_experiences', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('resume_id')->unsigned()->index();
			$table->bigInteger('company_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->json('title');
			$table->enum('employment_type', array('full_time', 'part_time', 'self_employed', 'freelance', 'contract', 'internship', 'apprenticeship', 'seasonal'));
			$table->json('description')->nullable();
			$table->tinyInteger('position')->unsigned();
			$table->bigInteger('parent_id')->unsigned()->nullable();
			$table->timestamp('start_at');
			$table->timestamp('end_at')->nullable();
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('work_experiences');
	}
}