<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactInfoTable extends Migration {

	public function up()
	{
		Schema::create('contact_info', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->json('title');
			$table->enum('type', array('email', 'mobile', 'phone', 'linkedin', 'other'))->index();
			$table->string('value')->index();
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('contact_info');
	}
}