<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResumesTable extends Migration {

	public function up()
	{
		Schema::create('resumes', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->string('title', 50);
			$table->json('first_name');
			$table->json('last_name');
			$table->enum('gender', array('man', 'female', 'unknown'))->index();
			$table->text('about_me')->nullable();
			$table->bigInteger('parent_id')->unsigned()->nullable()->index();
			$table->uuid('uuid')->unique();
			$table->timestamp('birthday')->nullable()->index();
			$table->timestamps();
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('resumes');
	}
}