<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Driver extends Eloquent {

	protected $table = 'drivers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'plate_number', 'mobile_number');

	public function DrivePaths()
	{
		return $this->hasMany('DrivePath');
	}

	public function WaitPoints()
	{
		return $this->hasMany('WaitPoint');
	}

}