<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDrivePointsTable extends Migration {

	public function up()
	{
		Schema::create('drive_points', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('drive_path_id')->unsigned();
			$table->string('point_type')->nullable()->index();
			$table->integer('point_id')->nullable();
			$table->float('location_lat');
			$table->float('location_long');
		});
	}

	public function down()
	{
		Schema::drop('drive_points');
	}
}