<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('drive_paths', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('drive_points', function(Blueprint $table) {
			$table->foreign('drive_path_id')->references('id')->on('drive_paths')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wait_points', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('request_points', function(Blueprint $table) {
			$table->foreign('passenger_id')->references('id')->on('passengers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('request_points', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('destinations', function(Blueprint $table) {
			$table->foreign('passenger_id')->references('id')->on('passengers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('point_relations', function(Blueprint $table) {
			$table->foreign('point_a')->references('id')->on('waypoints')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('point_relations', function(Blueprint $table) {
			$table->foreign('point_b')->references('id')->on('waypoints')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('drive_paths', function(Blueprint $table) {
			$table->dropForeign('drive_paths_driver_id_foreign');
		});
		Schema::table('drive_points', function(Blueprint $table) {
			$table->dropForeign('drive_points_drive_path_id_foreign');
		});
		Schema::table('wait_points', function(Blueprint $table) {
			$table->dropForeign('wait_points_driver_id_foreign');
		});
		Schema::table('request_points', function(Blueprint $table) {
			$table->dropForeign('request_points_passenger_id_foreign');
		});
		Schema::table('request_points', function(Blueprint $table) {
			$table->dropForeign('request_points_driver_id_foreign');
		});
		Schema::table('destinations', function(Blueprint $table) {
			$table->dropForeign('destinations_passenger_id_foreign');
		});
		Schema::table('point_relations', function(Blueprint $table) {
			$table->dropForeign('point_relations_point_a_foreign');
		});
		Schema::table('point_relations', function(Blueprint $table) {
			$table->dropForeign('point_relations_point_b_foreign');
		});
	}
}