<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Driver extends Model 
{

    protected $table = 'drivers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'plate_number', 'mobile_number');

    public function DrivePaths()
    {
        return $this->hasMany('DrivePath');
    }

    public function WaitPoints()
    {
        return $this->hasMany('WaitPoint');
    }

}