<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DrivePoint extends Model 
{

    protected $table = 'drive_points';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function DrivePath()
    {
        return $this->belongsTo('DrivePath');
    }

    public function WayPoint()
    {
        return $this->hasOne('Waypoint');
    }

    public function Destination()
    {
        return $this->hasOne('Destination');
    }

}