<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title', 191);
			$table->string('image', 191)->nullable();
			$table->string('media', 191)->nullable();
			$table->decimal('price', 10, 0)->nullable();
			$table->mediumText('short_text')->nullable();
			$table->longText('description')->nullable();
			$table->string('download', 191)->nullable();
			$table->integer('category_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}