<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('training_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->boolean('status')->default(FALSE);
			$table->datetime('payment_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}