<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->integer('city_id')->unsigned();
			$table->string('password');
			$table->string('whatsapp_number');
			$table->string('image_url');
			$table->boolean('is_open');
			$table->integer('delivery_fee')->unsigned();
			$table->integer('min_order')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}