<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->unsigned();
			$table->integer('payment_id')->unsigned();
			$table->string('state');
			$table->string('notes');
			$table->decimal('subtotal', 8,2);
			$table->decimal('delivery_fee', 8,2);
			$table->decimal('comission', 8,2);
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}