<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'created_by', 'updated_by');

	public function permissions()
	{
		return $this->hasMany('App\Models\Permissions');
	}

}