<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reservation extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'branch_id', 'status', 'date', 'time', 'discount', 'total_price', 'main_price', 'created_by', 'updated_by');

	public function client()
	{
		return $this->belongsTo('App\Models\Client', 'client_id');
	}

}