<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Provider extends Eloquent {

	protected $table = 'providers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone1', 'phone2', 'created_by', 'updated_by');

	public function stocks()
	{
		return $this->hasMany('App\Models\Store', 'provider_id');
	}

}