<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Item extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'min_amount', 'price_avg', 'rate', 'created_by', 'updated_by');

	public function stocks()
	{
		return $this->hasMany('App\Models\Store', 'item_id');
	}

}