<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFinanceCashTable extends Migration {

	public function up()
	{
		Schema::create('finance_cash', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('amount');
			$table->date('date')->nullable();
			$table->enum('status', array('pending', 'paid', 'pending'))->nullable();
			$table->bigInteger('finance_category_id')->unsigned();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('finance_cash');
	}
}