<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubmissionTable extends Migration {

	public function up()
	{
		Schema::create('submission', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('lesson_id')->unique();
			$table->integer('competition_id')->index();
			$table->integer('autospecs')->unsigned()->default('0');
			$table->text('autospecs_data');
			$table->integer('evaluation')->unsigned()->default('0');
			$table->text('evaluation_data');
		});
	}

	public function down()
	{
		Schema::drop('submission');
	}
}