<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('questionnaire_id', 'slug', 'libelle', 'statut');
	protected $visible = array('questionnaire_id', 'slug', 'libelle', 'statut');

	public function questionnaire()
	{
		return $this->belongsTo('App\Models\Questionnaire', 'questionnaire_id');
	}

	public function reponseQuestion()
	{
		return $this->hasMany('App\Models\ReponseQuestion', 'question_id');
	}

}