<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Position extends Eloquent {

	protected $table = 'positions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'nom', 'statut');
	protected $visible = array('slug', 'nom', 'statut');

	public function positionPhoto()
	{
		return $this->hasMany('App\Models\PositionPhoto', 'position_id');
	}

}