<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Menu extends Eloquent {

	protected $table = 'menus';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ceremonie_id', 'slug', 'nom', 'groupe', 'description', 'statut');
	protected $visible = array('ceremonie_id', 'slug', 'nom', 'groupe', 'description', 'statut');

	public function ceremonie()
	{
		return $this->belongsTo('App\Models\Ceremonie', 'ceremonie_id');
	}

}