<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InviteReponseQuestion extends Eloquent {

	protected $table = 'invites_reponses_questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'invite_id', 'reponse_question_id', 'statut');
	protected $visible = array('slug', 'invite_id', 'reponse_question_id', 'statut');

	public function invite()
	{
		return $this->belongsTo('App\Models\Invite', 'invite_id');
	}

	public function reponseQuestion()
	{
		return $this->belongsTo('App\Models\ReponseQuestion', 'reponse_question_id');
	}

}