<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AdminEvenement extends Eloquent {

	protected $table = 'admins_evenements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('evenement_id', 'global_admin_id', 'slug', 'role', 'matricule', 'pass', 'nom', 'statut');
	protected $visible = array('evenement_id', 'global_admin_id', 'slug', 'role', 'matricule', 'pass', 'nom', 'statut');

	public function evenement()
	{
		return $this->belongsTo('App\Models\Evenement', 'evenement_id');
	}

	public function globaleAdmin()
	{
		return $this->belongsTo('App\Models\GlobalAdmin', 'globale_admin_id');
	}

}