<?php

namespace App\Models;

class Setting extends Eloquent {

	protected $table = 'lim_settings';
	public $timestamps = true;
	protected $fillable = array('table_type', 'table_id', 'system_name');
	protected $visible = array('table_type', 'table_id', 'system_name');

	public function language()
	{
		return $this->hasOne('App\Models\SettingLanguage', 'lim_setting_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function languages()
	{
		return $this->hasMany('App\Models\SettingLanguage', 'lim_setting_id');
	}

}