<?php

namespace App\Models;

class Image extends Eloquent {

	protected $table = 'lim_images';
	public $timestamps = true;
	protected $fillable = array('table_type', 'table_id', 'rank', 'path');
	protected $visible = array('table_type', 'table_id', 'rank', 'path');

	public function languages()
	{
		return $this->hasMany('App\Models\ImageLanguage', 'lim_image_id');
	}

	public function language()
	{
		return $this->hasOne('App\Models\ImageLanguage', 'lim_image_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function table()
	{
		return $this->morphTo();
	}

}