<?php

namespace App\Models;

class GalleryTemplates extends Eloquent {

	protected $table = 'lim_gallery_templates';
	public $timestamps = true;
	protected $fillable = array('template_file');
	protected $visible = array('template_file');

	public function language()
	{
		return $this->hasOne('App\Models\GalleryTemplateLanguage', 'lim_gallery_template_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function languages()
	{
		return $this->hasMany('App\Models\GalleryTemplateLanguage', 'lim_gallery_template_id');
	}

	public function galleries()
	{
		return $this->hasMany('App\Models\Gallery', 'lim_gallery_template_id');
	}

}