<?php

namespace App\Models;

class ContentTypeLanguage extends Eloquent {

	protected $table = 'lim_content_type_languages';
	public $timestamps = true;
	protected $fillable = array('lim_language_id', 'lim_content_type_id', 'name', 'plural_name', 'uri');
	protected $visible = array('lim_language_id', 'lim_content_type_id', 'name', 'plural_name', 'uri');

	public function language()
	{
		return $this->belongsTo('App\Models\Language', 'lim_language_id');
	}

	public function contentType()
	{
		return $this->belongsTo('App\Models\ContentType', 'lim_content_type_id');
	}

}