<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLimSettingLanguagesTable extends Migration {

	public function up()
	{
		Schema::create('lim_setting_languages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('lim_language_id')->unsigned();
			$table->integer('lim_setting_id')->unsigned();
			$table->string('label', 32);
			$table->string('value', 128)->nullable();
			$table->string('description', 128)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('lim_setting_languages');
	}
}