<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLimFieldItemsTable extends Migration {

	public function up()
	{
		Schema::create('lim_field_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('lim_field_id')->unsigned();
			$table->enum('status', array('0', '1'));
			$table->integer('rank')->unsigned()->default('0');
			$table->string('icon', 64)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('lim_field_items');
	}
}