<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLimContentLanguagesTable extends Migration {

	public function up()
	{
		Schema::create('lim_content_languages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('lim_language_id')->unsigned();
			$table->integer('lim_content_id')->unsigned();
			$table->string('uri', 128);
			$table->string('name', 128);
			$table->text('summary')->nullable();
			$table->string('content')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('lim_content_languages');
	}
}