<?php

namespace Models/Product;

class Product extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	public function sub_category()
	{
		return $this->belongsTo('Models/SubCategory\SubCategory', 'sub_category_id');
	}

	public function addons()
	{
		return $this->hasMany('Models/Addon\Addon', 'product_id');
	}

	public function images()
	{
		return $this->hasMany('Models/ProductImages\ItemImages', 'product_id');
	}

}