<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('quiz_section_id')->unsigned();
			$table->bigInteger('parent_id')->unsigned()->nullable();
			$table->string('question');
			$table->bigInteger('question_type_id')->unsigned();
			$table->string('descriptions');
			$table->boolean('is_need_answers')->default(true);
			$table->boolean('status')->default(true);
			$table->string('header_statement')->nullable();
			$table->string('footer_statement')->nullable();
			$table->boolean('is_chain');
			$table->bigInteger('question_choice_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}