<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionTableVariablesTable extends Migration {

	public function up()
	{
		Schema::create('question_table_variables', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('question_id')->unsigned();
			$table->string('name');
			$table->bigInteger('input_type_id')->unsigned();
			$table->string('descriptions')->nullable();
			$table->boolean('status')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('question_table_variables');
	}
}