<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('Subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->string('price');
			$table->bigInteger('currency_id')->unsigned();
			$table->softDeletes();
			$table->string('expires_at');
		});
	}

	public function down()
	{
		Schema::drop('Subscriptions');
	}
}