<?php

namespace lhp;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NotaPemeriksaan extends Model 
{

    protected $table = 'np';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('np_nomor', 'np_tanggal', 'np_lhp', 'np_upt', 'np_temuan');
    protected $visible = array('np_nomor', 'np_tanggal', 'np_lhp', 'np_upt', 'np_temuan');

    public function getLhp()
    {
        return $this->hasOne('lhp\Lhp', 'np_lhp');
    }

    public function getUpt()
    {
        return $this->hasOne('upt\Upt', 'np_upt');
    }

    public function getNpTemuan()
    {
        return $this->hasMany('np\NpTemuan', 'np_temuan');
    }

}