<?php

namespace tpa_company;

use Illuminate\Database\Eloquent\Model;

class Tpa_company extends Model 
{

    protected $table = 'tpa_company';
    public $timestamps = true;

    public function users()
    {
        return $this->hasMany('Tpa_user');
    }

    public function vessels()
    {
        return $this->hasMany('Tpa_vessel');
    }

    public function submit_request_quotation()
    {
        return $this->hasMany('Tpa_request_quotation');
    }

    public function identification_type()
    {
        return $this->belongsTo('Tpa_identification_type', 'identification_type_id');
    }

    public function sector()
    {
        return $this->belongsTo('Tpa_company_sector', 'sector_id');
    }

    public function region()
    {
        return $this->belongsTo('Region', 'region_id');
    }

}