<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->hasOne('LocationGroup', 'id', 'group_id');
	}

	public function machines()
	{
		return $this->hasMany('Machine', 'location_id', 'id');
	}

}