<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->index();
			$table->string('title', 140)->index();
			$table->text('meta_data');
			$table->integer('sender_id');
			$table->integer('receiver_id');
			$table->text('body_raw');
			$table->text('body_parsed');
			$table->integer('folder_id')->unsigned()->index();
			$table->boolean('is_read');
			$table->boolean('is_important');
			$table->string('reference_uuid', 36);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}