<?php

namespace Beedask\Models;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;
	protected $fillable = array('topic_id', 'user_id', 'status_id', 'body', 'favorites_count_raw');
	protected $visible = array('topic_id', 'user_id', 'status_id', 'body', 'favorites_count_raw');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function topic()
	{
		return $this->belongsTo('Topic', 'topic_id');
	}

	public function status()
	{
		return $this->belongsTo('Status', 'status_id');
	}

	public function answers()
	{
		return $this->hasMany('Answer', 'question_id');
	}

	public function votes()
	{
		return $this->hasMany('Vote', 'question_id');
	}

	public function scores()
	{
		return $this->hasMany('Score', 'question_id');
	}

	public function favorites()
	{
		return $this->hasMany('Favorite', 'question_id');
	}

	public function pool()
	{
		return $this->hasMany('Pool', 'question_id');
	}

	public function comments()
	{
		return $this->hasMany('Comment', 'question_id');
	}

}