<?php

namespace Beedask\Models;

class Answer extends Eloquent {

	protected $table = 'answers';
	public $timestamps = true;
	protected $fillable = array('question_id', 'user_id', 'party_id', 'body');
	protected $visible = array('question_id', 'user_id', 'party_id', 'body');

	public function question()
	{
		return $this->belongsTo('Question', 'question_id');
	}

	public function member()
	{
		return $this->belongsTo('Member', 'user_id');
	}

	public function party()
	{
		return $this->belongsTo('Party', 'party_id');
	}

	public function votes()
	{
		return $this->hasMany('Vote', 'answer_id');
	}

	public function scores()
	{
		return $this->hasMany('Score', 'answer_id');
	}

}