<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function enrollment()
    {
        return $this->hasMany('Enrollment');
    }

    public function payment()
    {
        return $this->hasMany('Payment');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

}