<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchoollevelsTable extends Migration {

	public function up()
	{
		Schema::create('schoollevels', function(Blueprint $table) {
			$table->increments('id');
			$table->smallInteger('year')->unsigned()->index();
			$table->string('level', 2);
			$table->string('class', 5)->index();
			$table->integer('sid')->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('schoollevels');
	}
}