<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->index();
			$table->string('product_code', 191);
			$table->string('name', 191);
			$table->string('unit_price', 191)->nullable();
			$table->string('unit_size', 191);
			$table->text('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}